//=============================================================================
// Balloon subclass for liquid balloons, never spawned (on purpose lol!!)
//=============================================================================
class Balloon_liquid extends Balloon;

/* liquid balloons group contains the following balloons:
	- light 	(layers: 10, speed: 1.300000, key: O)
	- blue		(layers: 15, speed: 1.400000, key: P)
	- green		(layers: 20, speed: 1.500000, key: Q)
	- red		(layers: 25, speed: 1.600000, key: R)
*/

//light,blue and green mesh:
#exec obj load file=..\Textures\Liquids.utx package=Liquids
#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec mesh import mesh=LiquidBalloon anivfile=Models\LiquidBalloon_a.3d datafile=Models\LiquidBalloon_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=LiquidBalloon x=0 y=0 z=0
#exec mesh sequence mesh=LiquidBalloon seq=All startframe=0 numframes=1
#exec meshmap new meshmap=LiquidBalloon mesh=LiquidBalloon
#exec meshmap scale meshmap=LiquidBalloon x=0.12085 y=0.12085 z=0.24170

//red mesh:
#exec obj load file=..\Textures\LavaFX.utx package=LavaFX
#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec mesh import mesh=LiquidBalloon2 anivfile=Models\LiquidBalloon2_a.3d datafile=Models\LiquidBalloon2_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=LiquidBalloon2 x=0 y=0 z=0
#exec mesh sequence mesh=LiquidBalloon2 seq=All startframe=0 numframes=1
#exec meshmap new meshmap=LiquidBalloon2 mesh=LiquidBalloon2
#exec meshmap scale meshmap=LiquidBalloon2 x=0.12085 y=0.12085 z=0.24170

function SetColor()
{
	if ( Health <= 10 )
		{
		MultiSkins[0] = Texture'Liquids.liquid4';
		AirSpeed = BaseSpeed * 1.300000;
		DrawScale = Default.DrawScale * 0.9 * 0.9 * 0.9;
		}
	else if ( Health <= 15 )
		{
		MultiSkins[0] = Texture'Liquids.liquid3';
		AirSpeed = BaseSpeed * 1.400000;
		DrawScale = Default.DrawScale * 0.9 * 0.9;
		}
	else if ( Health <= 20 )
		{
		MultiSkins[0] = Texture'Liquids.liquid5';
		AirSpeed = BaseSpeed * 1.500000;
		DrawScale = Default.DrawScale * 0.9;
		}
	else
		{
		MultiSkins[0] = Texture'LavaFX.lava5';
		AirSpeed = BaseSpeed * 1.600000;
		}
}

defaultproperties
{
	 layers=1
	 health=1
	 speed=1.000000
     AmbientGlow=64
	 DrawType=DT_Mesh
	 Mesh=Mesh'LiquidBalloon'
	 CollisionRadius=16.00000
	 CollisionHeight=30.93823
	 DrawScale=0.5
	 bCanBeGlued=False
}
